from setuptools import setup, find_packages

setup(
    name='nanocern',
    version='1.0.0',
    description='Constraint-based reasoning engine using Knowledge Units',
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    author='Antigravity AI',
    author_email='nanocern@example.com',
    url='https://github.com/yourusername/nanocern',
    py_modules=['nanocern'],
    entry_points={
        'console_scripts': [
            'nanocern=nanocern:main',
        ],
    },
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Science/Research',
        'Topic :: Scientific/Engineering :: Artificial Intelligence',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
    ],
    python_requires='>=3.8',
    install_requires=[],
    include_package_data=True,
    package_data={
        '': ['atoms/*.ku'],
    },
)
