# NanoCERN CLI - Headless Knowledge Reactor

**Deterministic constraint-based reasoning engine with 648+ Knowledge Units**

## What is NanoCERN?

A deterministic reasoning system that encodes domain knowledge as **atomic constraints** (Knowledge Units). Every decision is explainable and traceable.

## Quick Start

```bash
# Install
cd nanocern_cli
pip install -e .

# Show statistics
nanocern stats

# List all Knowledge Units
nanocern list

# List KUs in specific domain
nanocern list --domain physics

# Search for KUs
nanocern search "gravity"

# Check constraint
nanocern check atoms/PHYS-1_F.ku --state '{"Value >": 1}'
```

## Knowledge Unit Structure

```json
{
  "id": "PHYS-1_F",
  "domain": "physics",
  "invariant": {
    "name": "(−1)F Operator",
    "expression": "(−1)F = B + L"
  },
  "applies_if": {"Value >": 0},
  "failure_modes": {
    "conditions": ["non-fermionic particles"],
    "behavior": "invalid"
  },
  "confidence": 0.95
}
```

## CLI Commands

### Statistics
```bash
nanocern stats
```
Shows total KU count, domain breakdown, and average confidence.

### List KUs
```bash
nanocern list                    # All KUs
nanocern list --domain physics   # Physics only
```

### Show Domains
```bash
nanocern domains
```

### Search
```bash
nanocern search "metformin"
nanocern search "gravity"
```

### Check Constraint
```bash
nanocern check atoms/PHYS-1_F.ku --state '{"Value >": 1}'
```

### Validate KU
```bash
nanocern validate atoms/PHYS-1_F.ku
```

## Included Domains

- **Physics**: 412 KUs (particle physics, optics, acoustics, etc.)
- **Mathematics**: 158 KUs (algebra, calculus, number theory)
- **Chemistry**: 75 KUs (reactions, compounds, properties)
- **Geography**: 2 KUs
- **Culture**: 1 KU

**Total: 648 Knowledge Units**

## Why Constraint-Based?

**Traditional ML**: Black box → confidence score  
**NanoCERN**: Explicit constraints → explainable reasoning

## Python API

```python
from nanocern import load_ku, check_constraint

ku = load_ku('atoms/PHYS-1_F.ku')
state = {"Value >": 1}
check_constraint(ku, state)
```

## KU Sources

All KUs consolidated from:
- Wikipedia extraction campaign
- Knowledge Reactor atoms
- Curated domain libraries

## License

MIT - See LICENSE file

---

*Built with 🥔 power - NanoWiki Project*

