# NanoCERN CLI v2.0 - Quick Reference

## Installation
```bash
cd /home/shri/Desktop/nanowiki/nanocern_cli
pip install -e .
```

## Commands

### 📊 Stats
```bash
nanocern stats
```
Shows total KUs, average confidence, and domain breakdown with visual charts.

### 🏷️ Domains
```bash
nanocern domains
```
Lists all 5 available domains with KU counts.

### 🔍 Search
```bash
nanocern search "gravity"
nanocern search "entropy"
```
Find KUs by keyword in ID, domain, or invariant.

### 📋 List
```bash
nanocern list                    # All KUs
nanocern list --domain physics   # Physics only
nanocern list --domain mathematics
```

### ✅ Check Constraint
```bash
nanocern check atoms/PHYS-ARCADE.ku --state '{"Value >": 1}'
```

### 🔬 Validate
```bash
nanocern validate atoms/PHYS-ARCADE.ku
```

## Library Stats
- **Total KUs**: 648 unique
- **Domains**: Physics (412), Mathematics (158), Chemistry (75), Geography (2), Culture (1)
- **Binary Files**: 653 .ku files
- **Successfully Loading**: 178 KUs
- **JSON Format**: All 648 KUs available in consolidated_kus.json

## Files
- `nanocern.py` - Enhanced CLI
- `atoms/` - 653 binary .ku files
- `consolidated_kus.json` - All KUs in JSON (515 KB)
- `manifest.json` - Library metadata
- `validation_report.json` - Validation results
- `README.md` - Full documentation

## Example Workflow
```bash
# See what's available
nanocern stats

# Find KUs about a topic
nanocern search "thermodynamics"

# List all physics KUs
nanocern list --domain physics

# Check a specific constraint
nanocern check atoms/PHYS-ENTROPY.ku --state '{"Temperature": 300}'
```

## Status: ✅ READY FOR USE
