# ISL Reproducibility & Methods Appendix
**Subject**: Quantitative verification of the NGC 3198 rotation curve fit.

## 1. Dataset Selection
The fit utilizes data from the **SPARC (Spitzer Photometry & Accurate Rotation Curves)** database and Begeman (1989). 
- **Target**: NGC 3198 (Spiral Galaxy)
- **Input Data**: Radial distance (kpc), Observed circular velocity $V_{obs}$ (km/s), Stellar disk component $V_{disk}$ (M/L=1), and Gas component $V_{gas}$.

## 2. Model Functional Form
The ISL gravity model assumes an effective gravitational coupling that runs linearly with distance:
$$ V_{model}^2(r) = \left[ \Upsilon_* V_{disk}^2(r) + V_{gas}^2(r) \right] \cdot \left( 1 + \frac{r}{r_{mod}} \right) $$
Where:
- $\Upsilon_*$ is the stellar mass-to-light ratio (free parameter).
- $r_{mod}$ is the Universal Modularity Radius (free parameter).

## 3. Optimization Parameters
- **Algorithm**: Grid search / Least Squares minimization.
- **Stellar M/L Range**: [0.5, 1.5]
- **Modularity Radius Range**: [5.0 kpc, 50.0 kpc]

## 4. Best Fit Results
- **Stellar M/L**: 0.847
- **$r_{mod}$**: 13.27 kpc
- **Reduced $\chi^2$ (9 points, 2 DOF free)**: **0.999**

## 5. Raw Data Package
The complete residuals and prediction table is available in [NGC3198_REPRODUCIBILITY.json](./reports/NGC3198_REPRODUCIBILITY.json). 

| Radius (kpc) | $V_{obs}$ | $V_{pred}$ | Residual | Error |
|--------------|-----------|-----------|----------|-------|
| 2.0          | 62.2      | 56.63     | 5.57     | 5.0   |
| 4.0          | 115.7     | 108.80    | 6.90     | 5.0   |
| 8.0          | 144.8     | 152.24    | -7.44    | 5.0   |
| 12.0         | 152.8     | 157.14    | -4.34    | 5.0   |
| 16.0         | 155.1     | 156.60    | -1.50    | 5.0   |
| 20.0         | 156.9     | 154.87    | 2.03     | 5.0   |
| 24.0         | 157.0     | 154.03    | 2.97     | 5.0   |
| 28.0         | 155.0     | 155.31    | -0.31    | 5.0   |
| 30.0         | 154.0     | 156.57    | -2.57    | 5.0   |

**Verification Verdict**: The fit accurately captures the kinematic plateau beyond 10 kpc, where Newtonian dynamics typically fail.
