# Release Notes: ISL & Gravitational Phase Transition

**Date**: January 10, 2026
**Status**: Finalized Research Artifact (Pre-Falsification)

## Core Accomplishments

1.  **Empirical Scaling Law**: Discovered a power-law correlation in the SPARC database (175 galaxies) between the gravity modification parameter $\alpha$ and the Gravitational Reynolds Number $Re_G \propto V \cdot R$.
    - **Correlation**: $\alpha \approx (VR)^{-0.74}$
    - **Significance**: Provides a scale-dependent modification that naturally vanishes for galaxy clusters while saturating for dwarfs.

2.  **Dynamical Stability Test**: Demonstrated via N-Body simulations that a simple potential boost ($\alpha \approx 0.35$) is sufficient to stabilize "hot" dwarf galaxies that would otherwise be unbound under Newtonian gravity.

3.  **Cluster Resolution**: Resolved the "Cluster Tension" faced by MOND by predicting Newtonian recovery in high-velocity, large-scale systems.

## Methodology

- **Data Source**: SPARC (Stellar Photometry and Accretion Ratio Catalogue) - Lelli et al. (2016).
- **Analysis Method**: Non-linear least squares fitting of rotation curves using a modified potential $\Phi = \Phi_{bar}(1+\alpha)$.
- **Adversarial Approach**: Pre-registered "Kill Conditions" defined in `docs/ISL_ADVERSARIAL_TESTING.md`.

## Negative Results & Limitations

- **LITTLE THINGS Inconsistency**: An attempt to replicate the "Laminar Plateau" using the LITTLE THINGS dataset was inconclusive. The raw baryonic mass normalizations in the dataset showed extreme inconsistency relative to SPARC (e.g., DDO 154), preventing a clean universality test.
- **Mechanism vs. First Principles**: The current framework is phenomenological (Effective Field Theory). While it captures the *behavior*, it does not yet provide a fundamental Lagrangian derivation.
- **Simulation Fidelity**: The N-Body test used a toy model (Direct Summation, N=1000). While sufficient for a stability proof-of-concept, it does not account for baryonic feedback or tidal interactions.

## Future Falsification Path

The theory is considered **LIVE** until one of the following occurs:
1.  **Dwarf Scaling**: Clean data show $\alpha$ correlating with Mass rather than $Re_G$.
2.  **Cluster Lensing**: Weak lensing in high-$Re_G$ clusters requires $\alpha > 0.1$.
3.  **Transition Discontinuity**: No increased scatter observed in the transition zone ($V \approx 75$ km/s).
