# ISL Mechanism Test Protocol: Toy N-Body Simulation
**Pre-Registered Criteria for Falsification**

**Objective**: To test if the Gravitational Phase Transition (specifically the "Laminar Plateau" where $\alpha \approx 0.35$) provides the necessary dynamical stability to Dwarf Galaxies without Dark Matter.

**Hypothesis**:
- **Newtonian Limit**: A dwarf galaxy initialized with high velocity dispersion (observed values) but only Baryonic Mass will be unstable and evaporate/fly apart.
- **ISL Laminar Limit**: The same galaxy, under ISL gravity with $\alpha \approx 0.35$, will remain gravitationally bound and stable.

---

## 1. Simulation Setup

### 1.1 Methodology
- **Type**: Direct Summation N-Body (Python/NumPy).
- **Particles**: $N = 1000$ (sufficient for toy stability).
- **Dimensions**: 3D positions, 3D velocities.
- **Time Integration**: Leapfrog or Runge-Kutta (RK4).

### 1.2 The Force Law
Standard Newtonian Gravity modified by the ISL Phase Factor:
$$ \vec{F}_{ij} = -G \frac{m_i m_j}{|\vec{r}_{ij}|^3} \vec{r}_{ij} \times \left( 1 + \alpha_{eff} \right) $$

where $\alpha_{eff}$ is determined by the Global Reynolds Number of the system:
- **Dwarf Mode**: $Re_G < 1000 \rightarrow \alpha_{eff} = 0.35$
- **Giant Mode**: $Re_G \gg 1000 \rightarrow \alpha_{eff} = 0.00$

### 1.3 Initial Conditions (The Dwarf Test)
We initialize a "Baryon Only" Dwarf Galaxy:
- **Mass**: $M_{bar} = 10^8 M_{\odot}$.
- **Radius**: $R_{eff} = 2$ kpc.
- **Velocity Dispersion**: $\sigma \approx 20-30$ km/s (chosen to match observation, which is "too fast" for Newtonian gravity).
- **Virial Ratio**: $Q = \frac{2K}{|W|}$.
  - Newtonian: $Q > 1$ (Unbound/Unstable).
  - ISL: $Q \approx 1$ (Bound/Stable due to deepened potential well).

---

## 2. Falsification Criteria (Kill Conditions)

The mechanism is **FAILED** if:

### ❌ Kill 1: Evaporation check
The "Stable" ISL Dwarf ($ \alpha = 0.35 $) evaporates or expands uncontrollably ($R_{half} \rightarrow \infty$).
- This means the "Modularity Overhead" is insufficient to mimic a Halo.

### ❌ Kill 2: Collapse check
The galaxy collapses into a dense singularity instead of maintaining a "puffy" dispersion-supported shape.
- This means the force modification alters the orbital structure incorrectly.

### ❌ Kill 3: No Distinction
If the Newtonian Dwarf ($\alpha=0$) behaves identically to the ISL Dwarf (i.e., both stable or both unstable), then the mechanism has no explanatory power for the Missing Mass problem.

---

## 3. Success Conditions (Pass)
- **Newtonian Control**: Flies apart (Unbound).
- **ISL Test**: Remains bound (Stable Radius).
- **Metrics**: Conservation of Energy (checked to ensure code validity), Stability of Half-Mass Radius.
