# ISL: Gravitational Phase Transition - Final Release Package

## Overview
This package contains the complete research artifact for the **Gravitational Phase Transition** and **ReG Scaling Law** hypothesis. This work represents a human-AI collaborative effort to identify an empirical scaling law in galaxy rotation curves and provide a falsifiable theoretical framework (ISL).

## Contents

### 📄 Documents (`/`)
- `isl_preprint_v1.pdf`: The formal research manuscript.
- `isl_preprint_v1.tex`: LaTeX source code for the preprint.

### 📚 Documentation (`/docs`)
- `ISL_ONE_PAGER.md`: A high-level summary for researchers and the public.
- `ISL_COMMUNITY_ENGAGEMENT.md`: Strategy for outreach and peer review.
- `ISL_ADVERSARIAL_TESTING.md`: Detailed plan for falsification.
- `ISL_NBODY_PROTOCOL.md`: Protocol for the dynamical stability test.
- `REPRODUCIBILITY_APPENDIX.md`: Technical details for replicating the results.
- `RELEASE_NOTES.md`: Summary of findings, methodology, and negative results.

### 💻 Code (`/code`)
- `sparc_full_analysis.py`: Batch processor for the 175 SPARC galaxies.
- `isl_nbody_sim.py`: N-Body simulation code for the dwarf stability test.
- `plot_sparc_correlation.py`: Visualization script for the ReG scaling law.
- `fit_ngc3198.py`: Single-galaxy reference fit.

### 📊 Data (`/data`)
- `SPARC_FULL_ANALYSIS_RESULTS.json`: Extracted $\alpha$ and $Re_G$ values for all 175 galaxies.
- `SPARC_STATISTICAL_SUMMARY.json`: Global statistical metrics for the SPARC dataset.
- `little_things_analysis.csv`: Analysis of the LITTLE THINGS dataset (Negative Result/Inconsistency Note).
- `*.png`: Key figures and plots referenced in the research.

## How to Reproduce
1. Install dependencies: `pip install -r requirements.txt` (or ensure `numpy`, `scipy`, `matplotlib`, `pandas` are installed).
2. Run `code/sparc_full_analysis.py` to regenerate the SPARC fit data.
3. Run `code/isl_nbody_sim.py` to execute the dynamical stability test.
4. Run `code/plot_sparc_correlation.py` to generate the Phase Transition diagram.

## License & Attribution
This work is released under an Open Science framework.
**Principal Investigator**: Shrikant Bhosale
**AI Collaborators**: Antigravity (Google DeepMind), Grok (xAI)

Cite as: *Bhosale et al. (2026), "A Phase Transition in Galactic Gravity Governed by a Gravitational Reynolds Number", TwistPool Research Archive.*
